alias jukebox { dialog -mdo jukebox jukebox }
alias jukeprefs { dialog -mo jukeprefs jukeprefs }
alias jukeinfo { dialog -mo jukeinfo jukeinfo }
alias jukecrdts { dialog -mo jukecrdts jukecrdts }

dialog jukebox {
  title "GameAmp mp3 System"
  size -1 -1 196 153
  option dbu
  box "", 1, 4 3 188 32
  edit " ", 2, 8 10 180 10, center read
  edit " ", 3, 8 21 20 10, right read
  edit " ", 4, 44 21 20 10, right read
  edit " ", 5, 80 21 20 10, right read
  edit " ", 6, 120 21 20 10, right read
  edit " ", 7, 156 21 32 10, center read
  text "MB", 8, 30 23 9 6
  text "Min", 9, 67 23 12 8
  text "Kbps", 10, 102 23 14 8
  text "KHz", 11, 142 23 12 8
  list 12, 4 40 118 87, vsbar size
  box "", 13, 125 37 67 90
  button "Directory", 14, 128 44 61 10
  button "IRC Preferences", 15, 128 61 61 10
  button "Music Information", 16, 128 73 61 10
  check "Continuous Play", 17, 128 85 61 10, push
  check "Random Play", 18, 128 97 61 10, push
  button "Credits", 19, 128 114 61 10
  box "", 20, 4 128 86 21
  button "<<", 21, 7 134 16 12
  button ">", 22, 23 134 16 12
  button "II", 23, 39 134 16 12
  button "[ ]", 24, 55 134 16 12
  button ">>", 25, 71 134 16 12
  box "", 26, 100 128 22 21
  button "+", 27, 103 134 16 6
  button "--", 28, 103 140 16 6
  button "Close", 29, 148 136 44 12, ok
}

dialog jukeprefs {
  title "IRC Preferences"
  size -1 -1 152 81
  option dbu
  box " When a music starts: ", 1, 4 3 144 57
  radio " Do not show any information", 2, 9 16 108 8
  radio " Show information only for me", 3, 9 26 108 8
  radio " Show information in active chat window", 4, 9 36 108 8
  radio " Show information in all channels", 5, 9 46 108 8
  text "(/echo)", 6, 121 26 24 8
  text "(/msg)", 7, 121 36 24 8
  text "(/amsg)", 8, 121 46 28 8
  text " ", 9, 11 68 60 8, disabled
  button "OK", 10, 104 65 44 12, ok
}

dialog jukeinfo {
  title "Music Information"
  size -1 -1 132 160
  option dbu
  box "", 1, 4 2 124 108
  text "Album:", 2, 8 10 28 8
  text "Title:", 3, 8 18 28 8
  text "Artist:", 4, 8 26 28 8
  text "Year:", 5, 8 34 28 8
  text "Comment:", 6, 8 42 28 8
  text "Genre:", 7, 8 50 28 8
  text "Track:", 8, 8 58 28 8
  text "Length:", 9, 8 66 28 8
  text "Version:", 10, 8 74 28 8
  text "Bitrate:", 11, 8 82 28 8
  text "Sample:", 12, 8 90 28 8
  text "Mode:", 13, 8 98 28 8
  text " ", 14, 40 10 84 8
  text " ", 15, 40 18 84 8
  text " ", 16, 40 26 84 8
  text " ", 17, 40 34 84 8
  text " ", 18, 40 42 84 8
  text " ", 19, 40 50 84 8
  text " ", 20, 40 58 84 8
  text " ", 21, 40 66 84 8
  text " ", 22, 40 74 84 8
  text " ", 23, 40 82 84 8
  text " ", 24, 40 90 84 8
  text " ", 25, 40 98 84 8
  box "", 26, 4 112 124 27
  text "Copyright:", 27, 8 120 28 8
  text "Private:", 28, 8 128 28 8
  text "VBR:", 29, 76 120 28 8
  text "CRC:", 30, 76 128 28 8
  text " ", 31, 40 120 20 8
  text " ", 32, 40 128 20 8
  text " ", 33, 96 120 20 8
  text " ", 34, 96 128 20 8
  text " ", 35, 12 146 60 8, disabled
  button "Close", 36, 84 144 44 12, ok
}

dialog jukecrdts {
  title "Credits"
  size -1 -1 136 69
  option dbu
  text "HMM", 4, 8 12 80 8
  button "Aight", 3, 44 55 44 12, cancel
}

on *:dialog:jukebox:init:0: {
  did -f jukebox 29
  if ( %jb.32 == on ) { did -c jukebox 17 }
  if ( %jb.33 == on ) { did -c jukebox 18 }
  if ( $exists(playlist.txt) == $true ) { jbplist }
  if ( %jb.02 != $null ) { did -c jukebox 12 %jb.02 }
  if ( $inmp3 == $true ) { jbinfo1 }
  if (( $inmp3 == $true ) && ( %jb.34 == on )) {
    .timerjb1 -o 0 1 jbcheck
    .timerjb2 -o 0 1 did -ra jukebox 2 - P A U S E D -
    .timerjb3 -o 0 2 did -ra jukebox 2 %jb.20 
  }
}

on *:dialog:jukebox:sclick:*: {
  if ( $did == 14 ) { jbdir }
  if ( $did == 15 ) { jukeprefs }
  if ( $did == 16 ) { jukeinfo }
  if ( $did == 17 ) {
    if ( %jb.32 == on ) { set %jb.32 off }
    else { set %jb.32 on }
  }
  if ( $did == 18 ) {
    if ( %jb.33 == on ) { set %jb.33 off }
    else { set %jb.33 on }
  }
  if ( $did == 19 ) { jukecrdts }
  if ( $did == 21 ) { jbrew }
  if ( $did == 22 ) {
    if ( $did(jukebox,12).sel == $null ) { halt }
    if ( %jb.34 == on ) { splay -p resume | jbfix | halt }
    if ( %jb.33 == on ) { jbplay3 }
    else jbplay1
  }
  if ( $did == 23 ) {
    if ( $inmp3 == $true ) {
      if ( %jb.34 != on ) {
        splay -p pause
        set %jb.34 on
        .timerjb1 -o 0 1 jbcheck
        .timerjb2 -o 0 1 did -ra jukebox 2 - P A U S E D -
        .timerjb3 -o 0 2 did -ra jukebox 2 %jb.20
      }
      else {
        splay -p resume
        jbfix
      }
    }
    else halt
  }
  if ( $did == 24 ) {
    if ( $inmp3 == $false ) { halt }
    if ( %jb.34 == on ) { jbfix }
    splay -p stop
    did -r jukebox 2,3,4,5,6,7
  }
  if ( $did == 25 ) { jbfow }
  if ( $did == 27 ) { vol -p $calc($vol(mp3) + 5000) | jbvol }
  if ( $did == 28 ) { vol -p $calc($vol(mp3) - 5000) | jbvol }
}

on *:dialog:jukebox:dclick:12: { jbplay1 }

on *:dialog:jukeprefs:init:0:{
  if ( %jb.30 == $null ) { set %jb.30 2 }
  did -c jukeprefs %jb.30
  did -f jukeprefs 10
  .timerjb5 -om 1 500 jbblink1
  .timerjb6 -om 1 1000 jbblink2
}

on *:dialog:jukeprefs:sclick:* {
  if ( $did == 2 ) { set %jb.30 2 }
  if ( $did == 3 ) { set %jb.30 3 }
  if ( $did == 4 ) { set %jb.30 4 }
  if ( $did == 5 ) { set %jb.30 5 }
}

on *:dialog:jukeinfo:init:0: {
  .timerjb5 -om 1 500 jbblink3
  .timerjb6 -om 1 1000 jbblink4
  unset %jb.7*
  jbadvi
}

on *:dialog:jukeinfo:sclick:36: { unset %jb.7* }

on *:dialog:jukecrdts:sclick:7: { run http://ecesar.tsx.org }
on *:dialog:jukecrdts:sclick:8: { run mailto:lock@innocent.com }

alias jbdir {
  if ( $version < 5.82 ) { did -ra jukebox 2 Your mIRC version is earlier than 5.82. Please update your mIRC. }
  set %jb.01 $$sdir(\,m3rlin's mp3 System - Select your music folder)
  window -elhns @plist
  aline @plist $findfile(%jb.01,*.mp?,0,aline @plist $1-)
  if ( $exists(playlist.txt) == $true ) { .remove playlist.txt }
  filter -wf @plist playlist.txt *.mp?
  window -c @plist
  unset %jb.01 %jb.02
  jbplist
}

alias jbplist {
  did -r jukebox 12
  set %jb.10 1
  set %jb.11 $lines(playlist.txt)
  :loop
  set %jb.12 $read -l $+ %jb.10 playlist.txt
  set %jb.13 $nopath(%jb.12)
  if ( $right(%jb.13,4) == .mp3 ) { set %jb.13 $remove(%jb.13,.mp3) }
  did -a jukebox 12 %jb.13
  inc %jb.10
  if ( %jb.10 <= %jb.11 ) goto loop
  unset %jb.10 %jb.12 %jb.13
}

alias jbplay {
  if ( $dialog(jukebox).title == Icey'z mp3 System ) { did -c jukebox 12 %jb.02 }
  set %jb.03 $read -l $+ %jb.02 playlist.txt
  splay -p %jb.03
  jbinfo
  jbinfo1
  if ( %jb.30 == 3 ) { jbinfo2 }
  if ( %jb.30 == 4 ) { jbi }
  if (( %jb.30 == 5 ) && ( $server != $null )) { jbinfo3 }
}

alias jbplay1 {
  set %jb.02 $did(jukebox,12).sel
  jbplay
}

alias jbplay2 {
  inc %jb.02
  if ( %jb.02 <= %jb.11 ) { jbplay }
  else { set %jb.02 1 } { jbplay }
}

alias jbplay3 {
  set %jb.02 $rand(1,%jb.11)
  jbplay
}

alias jbinfo {
  set %jb.20 $replace($nopath(%jb.03),$chr(95),$chr(32))
  if ( $right(%jb.20,4) == .mp3 ) { set %jb.20 $remove(%jb.20,.mp3) }
  set %jb.21 $round($calc(($file(%jb.03).size)/1048576),1)
  set %jb.23 $mp3(%jb.03).bitrate
  set %jb.24 $calc(($mp3(%jb.03).sample)/1000)
  set %jb.25 $mp3(%jb.03).mode
  if ( %jb.25 == Joint Stereo ) { set %jb.25 Stereo }
  if ( %jb.25 == Single Channel ) { set %jb.25 Mono }
  set %jb.26 $int($calc($mp3(%jb.03).length / 1000))
  set %jb.27 $int($calc($mp3(%jb.03).length / 60000))
  set %jb.28 $calc(%jb.26 - (%jb.27 * 60))
  if ( %jb.28 < 10 ) { set %jb.28 $chr(48) $+ %jb.28 }
  set %jb.22 %jb.27 $+ : $+ %jb.28
  unset %jb.26 %jb.27 %jb.28
}

alias jbinfo1 {
  if ( $dialog(jukebox).title != m3rlin's mp3 System ) { goto end }
  did -ra jukebox 2 %jb.20
  did -ra jukebox 3 %jb.21
  did -ra jukebox 4 %jb.22
  did -ra jukebox 5 %jb.23
  did -ra jukebox 6 %jb.24
  did -ra jukebox 7 %jb.25
  :end
}

alias jbinfo2 { echo -a  0[(14 $+ %jb.20 $+ 0) $+ 14m0/14l0(14 $+ %jb.21 $+ mb $+ 0/14 $+ %jb.22 $+ m $+ 0)(14select'd music0[14Mass Msg0] }
alias jbinfo3 { amsg 0[(14 $+ %jb.20 $+ 0) $+ 14m0/14l0(14 $+ %jb.21 $+ mb $+ 0/14 $+ %jb.22 $+ m $+ 0)(14select'd music0[14Mass Msg0] }
alias jbinfo4 { msg 0[(14 $+ %jb.20 $+ 0) $+ 14m0/14l0(14 $+ %jb.21 $+ mb $+ 0/14 $+ %jb.22 $+ m $+ 0)(14select'd music0[14Mass Msg0] }


alias jbi {
  if ( $server == $null ) { goto end }
  if ( $active == Status Window ) { goto end }
  amsg $active 0[(14 $+ %jb.20 $+ 0) $+ 14m0/14l0(14 $+ %jb.21 $+ mb $+ 0/14 $+ %jb.22 $+ m $+ 0)(14select'd music0[14Mass Msg0]
  :end
}

alias jbvol {
  did -ra jukebox 2 Volume: $round($calc(($vol(mp3) / 65535) * 100),0) $+ $chr(37)
  .timerjb4 1 2 jbinfo4
}

alias jbfow {
  if ( $inmp3 == $false ) { halt }
  if ( %jb.34 == on ) { jbfix }
  set %jb.40 $calc($inmp3.pos + $round($calc($inmp3.length / 4),0))
  if ( %jb.40 <= $inmp3.length ) { splay -p %jb.03 %jb.40 }
  else {
    if ( %jb.33 == on ) { jbplay3 }
    else { jbplay2 }
  }
}

alias jbrew {
  if ( $inmp3 == $false ) { halt }
  if ( %jb.34 == on ) { jbfix }
  set %jb.42 $calc($inmp3.pos - $round($calc($inmp3.length / 4),0))
  if ( %jb.42 > 0 ) { splay -p %jb.03 %jb.42 }
  else { splay -p %jb.03 }
}

alias jbcheck {
  if ( $dialog(jukebox).title != m3rlin's mp3 System ) {
    .timerjb3 off
    .timerjb2 off
    .timerjb1 off
  }
  else halt
}

alias jbfix {
  unset %jb.34
  .timerjb3 off
  .timerjb2 off
  .timerjb1 off
  did -ra jukebox 2 %jb.20
}

alias jbadvi {
  set %jb.700 $mp3($inmp3.fname).album
  set %jb.701 $mp3($inmp3.fname).title
  set %jb.702 $mp3($inmp3.fname).artist
  set %jb.703 $mp3($inmp3.fname).year
  set %jb.704 $mp3($inmp3.fname).comment
  set %jb.705 $mp3($inmp3.fname).genre
  set %jb.706 $mp3($inmp3.fname).track
  set %jb.707 $mp3($inmp3.fname).length
  set %jb.708 $mp3($inmp3.fname).version
  set %jb.709 $mp3($inmp3.fname).bitrate
  set %jb.710 $mp3($inmp3.fname).sample
  set %jb.711 $mp3($inmp3.fname).mode
  set %jb.712 $mp3($inmp3.fname).copyright
  set %jb.713 $mp3($inmp3.fname).private
  set %jb.714 $mp3($inmp3.fname).vbr
  set %jb.715 $mp3($inmp3.fname).crc
  if ( %jb.700 == $null ) { did -ra jukeinfo 14 (no information) }
  else did -ra jukeinfo 14 %jb.700
  if ( %jb.701 == $null ) { did -ra jukeinfo 15 (no information) }
  else did -ra jukeinfo 15 %jb.701
  if ( %jb.702 == $null ) { did -ra jukeinfo 16 (no information) }
  else did -ra jukeinfo 16 %jb.702
  if ( %jb.703 == $null ) { did -ra jukeinfo 17 (no information) }
  else did -ra jukeinfo 17 %jb.703
  if ( %jb.704 == $null ) { did -ra jukeinfo 18 (no information) }
  else did -ra jukeinfo 18 %jb.704
  if ( %jb.705 == $null ) { did -ra jukeinfo 19 (no information) }
  else did -ra jukeinfo 19 %jb.705
  if ( %jb.706 == $null ) { did -ra jukeinfo 20 (no information) }
  else if ( %jb.706 == -1 ) { did -ra jukeinfo 20 (no information) }
  else did -ra jukeinfo 20 %jb.706
  if ( %jb.707 == $null ) { did -ra jukeinfo 21 (no information) }
  else did -ra jukeinfo 21 %jb.707  milliseconds
  if ( %jb.708 == $null ) { did -ra jukeinfo 22 (no information) }
  else did -ra jukeinfo 22 %jb.708
  if ( %jb.709 == $null ) { did -ra jukeinfo 23 (no information) }
  else did -ra jukeinfo 23 %jb.709  Kbps
  if ( %jb.710 == $null ) { did -ra jukeinfo 24 (no information) }
  else did -ra jukeinfo 24 %jb.710 Hz
  if ( %jb.711 == $null ) { did -ra jukeinfo 25 (no information) }
  else did -ra jukeinfo 25 %jb.711
  if ( %jb.712 == $true ) { did -ra jukeinfo 31 Yes }
  else  did -ra jukeinfo 31 No
  if ( %jb.713 == $true ) { did -ra jukeinfo 32 Yes }
  else did -ra jukeinfo 32 No
  if ( %jb.714 == $true ) { did -ra jukeinfo 33 Yes }
  else did -ra jukeinfo 33 No
  if ( %jb.715 == $true ) { did -ra jukeinfo 34 Yes }
  else did -ra jukeinfo 34 No
}

alias jbblink1 {
  if ( $dialog(jukeprefs).title == IRC Preferences ) { did -ra jukeprefs 9 MP3 }
  else halt
}

alias jbblink2 {
  if ( $dialog(jukeprefs).title == IRC Preferences ) { did -ra jukeprefs 9 m3rlin's mp3 System }
  else halt
}

alias jbblink3 {
  if ( $dialog(jukeinfo).title == Music Information ) { did -ra jukeinfo 35 MP3 }
  else halt
}

alias jbblink4 {
  if ( $dialog(jukeinfo).title == Music Information ) { did -ra jukeinfo 35 m3rlin's mp3 System }
  else halt
}

alias jbuninstall {
  if ( $dialog(jukebox).title == m3rlin's mp3 System ) { dialog -k jukebox jukebox }
  if ( $exists(playlist.txt) == $true ) { .remove playlist.txt }
  unset %jb.*
}

on 1:mp3end: {
  if ( $dialog(jukebox).title == m3rlin's mp3 System ) { did -r jukebox 2,3,4,5,6,7 }
  if ( %jb.32 == on ) && ( %jb.33 != on ) { jbplay2 }
  if ( %jb.32 == on ) && ( %jb.33 == on ) { jbplay3 }
  else halt
}

menu menubar {
  GameAmp mp3 System:.jukebox
}
